/* -*-c-*-
*******************************************************************************
*
* File:         pxdatdef.h
* Description:  definition of PPR internal types & def's
* Author:       Henrik Liebau
* Created:      06 Apr 2000, 11:29:08
* Modified:     Thu Jul 26 08:45:14 2001 by Henrik Liebau, BVS R&D
* Language:     C Include File
* Package:      PCI-X Protocol Permutator&Randomizer
* Status:       
*
* (C) Copyright 2000 by Agilent Technologies, All Rights Reserved.
*
*******************************************************************************
*/

#ifndef __pxdatdef_H__
#define __pxdatdef_H__

#include <xmutxdef.h>
#include <xdyndefs.h>

#ifndef __pxdef_H__
#include <pxdef.h>
#endif /* defined __pxdef_H__ */

#ifndef __pxgendef_H__
#include <pxgendef.h>
#endif /* defined __pxgendef_H__ */

#ifndef __pxblkdef_H__
#include <pxblkdef.h>
#endif /* defined __pxblkdef_H__ */

#ifndef __pxbehdef_H__
#include <pxbehdef.h>
#endif /* defined __pxbehdef_H__ */

#ifndef __pxrepdef_H__
#include <pxrepdef.h>
#endif /* defined __pxrepdef_H__ */

#define BXPPR_NOHANDLE BX_INVALID_HANDLE

/* first entry here is BX_PARAM_LAST in CAPI entry! */
/* with this we can just ask ppr OR capi... */

CLI typedef enum _bxppr_paramtype {
  BXPPR_PARAM_GEN = BX_PARAM_LAST+1,		/* generic info */
  BXPPR_PARAM_REPORT,				/* report info */

  BXPPR_PARAM_RI_BLK,				/* riblk info */
  BXPPR_PARAM_RI_BLKPERM,			/* riblk perm info */

  BXPPR_PARAM_RI_BEH,
  BXPPR_PARAM_RI_BEHPERM,

  BXPPR_PARAM_RT_BEH,
  BXPPR_PARAM_RT_BEHPERM,

  BXPPR_PARAM_CI_BEH,
  BXPPR_PARAM_CI_BEHPERM,

  BXPPR_PARAM_CT_BEH,
  BXPPR_PARAM_CT_BEHPERM,

  BXPPR_PARAM_LAST		/* $enumsize */
} bxppr_paramtype;

/*****************************************************************************
 * types used for reporting
 *****************************************************************************/
/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_stringtype
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_stringtype
{
  bx_charptrtype m_buf;
  bx_charptrtype m_insertPtr;

  size_t m_bufLen;
} bxppr_stringtype;

/*****************************************************************************
 * data types
 *****************************************************************************/
/*---------------------------------------------------------------------------*
 * union bxppr_proptype
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
typedef union _bxppr_proptype
{
  /* for general access: DWORD */
  bx_int32 		dwVal;

  /* the specific types */
  bxppr_gentype		gen;
  bxppr_riblkpermtype	riblkperm;
  bxppr_riblktype	riblk;
  bxppr_behpermtype	behperm;
  bx_ribehtype		ribeh;
  bx_rtbehtype		rtbeh;
  bx_cibehtype		cibeh;
  bx_ctbehtype		ctbeh;
  bxppr_reporttype	report;

  bxppr_riblkresulttype riblkresult;
  bxppr_behresulttype	behresult;
  bxppr_riblkgaptype	gap;

} bxppr_proptype;

/*---------------------------------------------------------------------------*
 * struct _bxppr_propdatatype
 *
 * Purpose	: holds property data for PPR settings
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_propdatatype
{
  bx_infotype m_pInfo;				/* dynamic info on props */
  
  bx_int32 * m_prop;				/* the data for the props */
} bxppr_propdatatype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_vartype
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_vartype
{
  const bx_param_infotype * m_pParamInfo; /* this is only a pointer! */

  bx_int32 * m_pList;			  /* the entered list */
  bx_int32 m_listLength;		  /* length of list */
} bxppr_vartype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_vardatatype
 *
 * Purpose	: holds variation data for PPR settings
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_vardatatype
{
  bxppr_propdatatype m_perm;		  /* the perm properties */

  bx_infotype m_pInfo;			  /* dynamic info on props */
  bxppr_vartype ** m_var;		  /* array of pointers to
					     the actual variation data */

  bxppr_listtype m_returnList;		  /* for returning lists */
} bxppr_vardatatype;

/*---------------------------------------------------------------------------*
 * struct _bxppr_datatype
 *
 * Purpose	: holds ALL PPR-X data related to one (opened!) testcard
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_datatype
{
  bx_handletype m_handle;		  /* handle to access the card */

  bxppr_propdatatype m_genData;		  /* generic data */
  bxppr_propdatatype m_reportData;	  /* report-related data */

  bxppr_vardatatype m_riblkData;	  /* ri block data */

  bxppr_vardatatype m_ribehData;	  /* ri behavior data */
  bxppr_vardatatype m_rtbehData;	  /* rt behavior data */
  bxppr_vardatatype m_cibehData;	  /* ci behavior data */
  bxppr_vardatatype m_ctbehData;	  /* ct behavior data */

  bxppr_stringtype m_string;		  /* general return string */
} bxppr_datatype;

/*---------------------------------------------------------------------------*
 * struct _bxppr_datalisttype
 *
 * Purpose	: for internal (global) list of PPR data elements
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_datalisttype
{
  bxppr_datatype m_data;		  /* the actual data */
  bx_mutextype m_dataLock;		  /* for locking access to this card */

  struct _bxppr_datalisttype * m_next;	  /* next item in list */
} bxppr_datalisttype;

/*****************************************************************************
 * result data structs, used for generation/reporting/results
 *****************************************************************************/

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_genlisttype
 *
 * Purpose	: holds info for generation lists
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_genlisttype
{
  const bxppr_vartype * m_varList;	  /* pointer to associated var */

  bx_int32 m_prime;			  /* prime number */
  bx_int32 * m_pList;			  /* the generation list */
} bxppr_genlisttype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_resulttype
 *
 * Purpose	: generic struct for results
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_resulttype
{
  bx_int32 m_numElem;			  /* number of elements */
  bx_int32 m_numPerm;			  /* total num of permutations */

  bxppr_propdatatype m_resultProp;	  /* contains all resultprops */

  bxppr_genlisttype * m_pGenList;	  /* the lists for all props */
} bxppr_resulttype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_grpresultdatatype
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_grpresultdatatype
{
  bx_int32 m_numElem;			  /* number of elements */
  bx_int32 m_numPerm;			  /* total num of permutations */

  bx_int32 m_grpPrime;			  /* prime for group */

  bx_int32 m_groupMember;

  bxppr_genlisttype ** m_pGenArray;	  /* pointer to lists */
} bxppr_grpresultdatatype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_behdataresulttype
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_behresultdatatype
{
  bx_int32 m_numGroups;			  /* number of groups */

  bxppr_grpresultdatatype * m_pGroups;	  /* the lists for all groups */

  bxppr_resulttype m_result;		  /* the result data */
} bxppr_behresultdatatype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_busaddrtype {
 *
 * Purpose	: struct for holding bus addresses ( hi + lo )
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_busaddrtype {
  bx_int32 m_lo;			  /* low part (bits 0-31)*/
  bx_int32 m_hi;			  /* high part (bits 32-63) */
} bxppr_busaddrtype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_blklisttype
 *
 * Purpose	: holds info for generated blocks (address etc.)
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_blklisttype
{
  bx_int32 m_permnum;			  /* permutation num */

  bxppr_busaddrtype m_busaddr;		  /* address of block */
  bx_int32 m_numbytes;
  bx_int32 m_byten;
  
  bx_int32 m_buscmd;

  bx_int32 m_completion;		  /* complete requests before */

  bx_int32 m_adbStatus;			  /* ADB status (Mephisto 3.0) */
  
  struct _bxppr_blklisttype * m_link[2];  /* link to previous and next */
} bxppr_blklisttype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_blkresultdatatype
 *
 * Purpose	: special result struct for block data
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_blkresultdatatype
{
  const bxppr_vartype * m_origCmdList;	  /*  original command list */
  const bxppr_vartype * m_readCmdList;	  /*  read cmd list (for WRC test) */

  bxppr_resulttype m_result;
  bxppr_blklisttype * m_pBlkList[2];	  /* the list of gen. blocks */
} bxppr_blkresultdatatype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_resultdatatype {
 *
 * Purpose	: struct containing the combined result data
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_resultdatatype {
  bxppr_blkresultdatatype	m_riblkResult;

  bxppr_behresultdatatype	m_ribehResult;
  bxppr_behresultdatatype	m_rtbehResult;
  bxppr_behresultdatatype	m_cibehResult;
  bxppr_behresultdatatype	m_ctbehResult;
} bxppr_resultdatatype;

/*---------------------------------------------------------------------------*
 * typedef struct _bxppr_perminfotype {
 *
 * Purpose	: 
 *---------------------------------------------------------------------------*/
typedef struct _bxppr_perminfotype {
  const bx_int32 * m_numPerm;		  /* number of perms */
  bx_int32 * m_prime;
} bxppr_perminfotype;

#if defined (PPRX_CALLBACK)
typedef int (*bxppr_cbtype) (const char *);
extern bxppr_cbtype g_cbFct[];
#endif /* defined (PPRX_CALLBACK) */

/*------------------ Do not add code below this line ------------------------*/
#endif /* defined __pxdatdef_H__ */
